;******************************************************************  
;That can't be modified by user.
;******************************************************************  
INCLUDE "NPH_RX_MCU.inc"

;------------------------------------------------------------------        
XTAL		EQU	1600		;*10KHz
FIF			EQU	20			;*10KHz

;_HI_SR_		EQU	25
;------------------------------------------------------------------        
DEVICE_NO	EQU	23h

BC_CFG1	EQU	00h
BC_DM1  EQU 05h

BC_OM   EQU 10h
BC_RXG1 EQU 11h
BC_SX1  EQU 12h
BC_SX2  EQU 13h
BC_SX3  EQU 14h
BC_SX4  EQU 15h

BC_RX1  EQU 17h
BC_RX2  EQU 18h
BC_RX3  EQU 19h

;BC_LD1  EQU 1Bh

BC_CFG0 EQU 39h

BC_I2C1 EQU 42h

;------------------------------------------------------------------
BC_CFG1_V	EQU		080h

MMDEXT_V	EQU		1
        


IF (RF_RX_CNT*TXN/2 <=50 )
BC_DM1_V	EQU	003h	; for high symbol rate
BC_RX1_V	EQU 066H
BC_RX3_V    EQU 08DH
ELSE
BC_RX3_V	EQU	0ADh
BC_DM1_V    EQU 007H
BC_RX1_V	EQU 07FH
ENDIF

#define 	FRDIV		0

IF	(FREQ < 38000)
	RF_BAND		EQU	0
	NFREQ		EQU	(FREQ-FIF)*(1<<FRDIV)*2
;	BC_RX1_V	EQU	07Fh
	BC_RX2_V	EQU	0B8h

ENDIF
IF	(FREQ >= 38000) AND (FREQ < 49000)
	RF_BAND		EQU	1
	NFREQ		EQU	(FREQ-FIF)*(1<<FRDIV)
;	BC_RX1_V	EQU	07Fh
	BC_RX2_V	EQU	0B8h

ENDIF	
IF	(FREQ >= 80000)
	RF_BAND		EQU	3	
	NFREQ		EQU	(FREQ-FIF)*(1<<FRDIV)
;	BC_RX1_V	EQU	07Fh
	BC_RX2_V	EQU	0B4h

ENDIF

;BC_LD1_V		EQU	071h

	D_N			EQU	((NFREQ*4)/(XTAL*5))
	D_K1		EQU	((NFREQ*4*16)-(D_N*XTAL*5*16))

	D_KH		EQU	(D_K1/(XTAL*5))
	D_KH1		EQU	((D_K1*256)-(D_KH*XTAL*5*256))

	D_KM		EQU	(D_KH1/(XTAL*5))
	D_KM1		EQU	((D_KH1*256)-(D_KM*XTAL*5*256))

	D_KL		EQU	(D_KM1/(XTAL*5))

BC_OM_V			EQU (RF_BAND << 5)
BC_RXG1_V		EQU	071h       ;071H FOR AGC ON, 079H FOR AGC OFF

BC_SX1_V	EQU		(MMDEXT_V << 7) + D_N		
BC_SX2_V	EQU		D_KL		
BC_SX3_V	EQU		D_KM		
BC_SX4_V	EQU		(60h +D_KH)

BC_CFG0_V	EQU		082h		; BC2302A/B 0C2h used
;BC_I2C1_V	EQU		001h

;------------------------------------------------------------------        
DELAY	MACRO
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1		
		ENDM

;------------------------------------
SCK_LO	MACRO
		CLR		SCK_PORT
		ENDM						
		
SCK_HI	MACRO
		SET		SCK_PORT
		ENDM								
		
;------------------------------------
SDA_IN	MACRO
		SET		SDA_DIR
		JMP		$+1
		ENDM
		
SDA_OUT	MACRO
		CLR		SDA_DIR
		JMP		$+1
		ENDM
		
SDA_LO	MACRO
		CLR		SDA_PORT
;		CLR		SDA_DIR
		ENDM						
		
SDA_HI	MACRO
;		SET		SDA_DIR
		SET		SDA_PORT
;		CLR		SDA_DIR
		ENDM								

SNZ_SDA	MACRO
		SNZ		SDA_PORT
		ENDM

SZ_SDA	MACRO
		SZ		SDA_PORT
		ENDM

;------------------------------------
I2C_STR	MACRO
		SDA_OUT
		SCK_HI
		SDA_HI
		DELAY
		SDA_LO
		ENDM
		
I2C_STP MACRO
		SDA_OUT
		SDA_LO
		DELAY
		SCK_HI
		DELAY
		SDA_HI
		DELAY
		ENDM
		

;------------------------------------------------------------------        
BC2302_DS	.SECTION	'data'
mBuf		DB	12	DUP(?)
mTemp		DB	2	DUP(?)

BC2302_CS    .SECTION  PAGE	'code'
;--------------------------------------------------------
;--------------------------------------------------------
public	_NPH_RX_Init
_NPH_RX_Init		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
			
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF
					
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	sbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]			
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			
			MOV		A,01h
			MOV		mBuf[1],A
			CALL	Write_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		sbi_Lp			
			RET			 
_NPH_RX_Init		ENDP

;--------------------------------------------------------
;--------------------------------------------------------
public		_Read_NPH_RX_Reg	
_Read_NPH_RX_Reg		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
			
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF
										
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	Rbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			MOV		A,01h
			MOV		mBuf[1],A
			CALL	Read_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		Rbi_Lp
			RET

_Read_NPH_RX_Reg		ENDP
			
;------------------------------------
PrmTab:
		DW	BC_CFG0 
		DW	BC_CFG0_V
		
		DW	BC_CFG1 
		DW	BC_CFG1_V
		
		DW	BC_DM1
		DW	BC_DM1_V
		
		DW	BC_OM
		DW	BC_OM_V
		
		DW	BC_RXG1
		DW	BC_RXG1_V
		
		DW	BC_SX1
		DW	BC_SX1_V
				
		DW	BC_SX2
		DW	BC_SX2_V
				
		DW	BC_SX3
		DW	BC_SX3_V
				
		DW	BC_SX4
		DW	BC_SX4_V

		DW	BC_RX1
		DW	BC_RX1_V
		
		DW	BC_RX2
		DW	BC_RX2_V
		
		DW	BC_RX3
		DW	BC_RX3_V 
		
;		DW	BC_LD1
;		DW	BC_LD1_V
		
;		DW	BC_I2C1
;		DW	BC_I2C1_V
PrmTabEnd:								

;--------------------------------------------------------
public _Entry_I2C_mode
_Entry_I2C_mode	PROC
			SDA_LO
			SDA_OUT
			DELAY
			SCK_LO
			CALL	_Delay_1ms
			CALL	_Delay_1ms
			RET
_Entry_I2C_mode	ENDP

;--------------------------------------------------------
public _Exit_I2C_mode
_Exit_I2C_mode	PROC
			MOV		A,BC_I2C1
			MOV		mBuf[0],A
			MOV		A,01h
			MOV		mBuf[2],A			
			MOV		A,01h
			MOV		mBuf[1],A
			JMP		Write_I2C_Multi_Byte
_Exit_I2C_mode	ENDP
;********************************************************
;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length, mBuff[9:2]=data
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
public Write_I2C_Multi_Byte
Write_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail

			MOV		A,mBuf[1]
			MOV		mTemp[1],A
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A
	wimb_Lp:	
			MOV		A,IAR0
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			INC		MP0					
			SDZ		mTemp[1]
			JMP		wimb_Lp
	wimb_Fail:
			CALL	I2C_Stop
			RET
Write_I2C_Multi_Byte	ENDP			

;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length
; output   : mBuf[9:2]
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
Read_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)+1
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A									
			MOV		A,mBuf[1]
			MOV		mTemp[1],A
	rimb_Lp:	
			CALL	I2C_GetByte
			MOV		IAR0,A
			INC		MP0
			
			SET		C
			SDZA	mTemp[1]			
			CLR		C
			CALL	I2C_SendAck
			SDZ		mTemp[1]	
			JMP		rimb_Lp
			
	rimb_Fail:			
			CALL	I2C_Stop
			RET
Read_I2C_Multi_Byte	ENDP			

;********************************************************
;--------------------------------------------------------
public	_I2C_Init
_I2C_Init		PROC
			SDA_HI		
			SCK_HI		
			CLR		SCK_DIR
			CLR		SDA_DIR
			
			MOV		A,32
			MOV		mTemp,A
		LOOP:
			CALL	_Delay_1ms
			SDZ		mTemp
			
			JMP		LOOP
			ret
_I2C_Init		ENDP

public	_RX_Off
_RX_Off		PROC
			SCK_HI
			SDA_OUT
			RET
_RX_Off		ENDP

public	_RX_On
_RX_On		PROC
			SDA_IN
			SCK_LO
			RET
_RX_On		ENDP

;--------------------------------------------------------
public	I2C_Start
I2C_Start	PROC
			I2C_STR
			RET
I2C_Start	ENDP
				
;--------------------------------------------------------
;--------------------------------------------------------
public	I2C_Stop
I2C_Stop	PROC
			I2C_STP
			RET
I2C_Stop	ENDP
				
;--------------------------------------------------------
; Input : ACC=Data
; Template : mTemp[0]
;--------------------------------------------------------
public	I2C_SendByte
I2C_SendByte	PROC
			SDA_OUT
			MOV		mTemp,A
			MOV		A,08h
	isb_Lp:		
			SCK_LO
			RLC		mTemp
			SZ		C
			JMP		$1			
	$0:
			SDA_LO
			JMP		$9						
	$1:		
			SDA_HI	
	$9:	
			JMP		$+1
			SCK_HI
			DELAY
			SDZ		ACC
			JMP		isb_Lp
			SCK_LO
			SDA_IN			
			RET
I2C_SendByte	ENDP

;--------------------------------------------------------
; Template : mTemp[0]
; Output : ACC
;--------------------------------------------------------
public I2C_GetByte
I2C_GetByte	PROC
			SDA_IN
			MOV		A,08h
	igb_Lp:		
			SCK_LO
			DELAY
			
			SCK_HI
			CLR		C
			SZ_SDA
			SET		C			
			RLC		mTemp
			
			SDZ		ACC
			JMP		igb_Lp
			
			SCK_LO
			MOV		A,mTemp			
			RET
I2C_GetByte	ENDP

;--------------------------------------------------------
; Input : C
;--------------------------------------------------------
I2C_SendAck	PROC
			SDA_OUT
			SZ		C
			JMP		$1
	$0:
			SDA_LO
			JMP		$9			
	$1:				
			SDA_HI	
	$9:
			SCK_HI
			DELAY
			SCK_LO
			RET
I2C_SendAck	ENDP

;--------------------------------------------------------
; Output : C
;--------------------------------------------------------
I2C_GetAck	PROC
			SDA_IN
;			DELAY
			SCK_HI
			DELAY
			CLR		C
			SZ_SDA
			SET		C		
			SCK_LO
			RET
I2C_GetAck	ENDP

;--------------------------------------------------------
;void	InitRxTM(void);
;--------------------------------------------------------
public	_InitRxTM
_InitRxTM	proc
			InitRxTM
			RET
_InitRxTM	endp

;--------------------------------------------------------
;void	RFTimerOn(void);
;--------------------------------------------------------
public	_RFTimerOn
_RFTimerOn	proc
			RFTimerOn
			RET
_RFTimerOn	endp

;--------------------------------------------------------
;void	RFTimerOff(void);
;--------------------------------------------------------
public	_RFTimerOff
_RFTimerOff	proc
			RFTimerOff
			RET
_RFTimerOff	endp

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_10us
Delay_10us	PROC
			MOV		A,4
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_10us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_100us
Delay_100us	PROC
			MOV		A,49
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_100us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	_Delay_1ms
_Delay_1ms	PROC
			MOV		A,167
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1

			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			RET
_Delay_1ms	ENDP



		